<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class RenameProductsCategoryToTestCategory extends Migration
{
    public function up()
    {
        if (Schema::hasColumn('products', 'category') && !Schema::hasColumn('products', 'test_category')) {
            DB::statement('ALTER TABLE products CHANGE category test_category VARCHAR(50) NULL COMMENT \'Lab test type: Blood Test, X-Ray, etc\'');
        }
    }

    public function down()
    {
        if (Schema::hasColumn('products', 'test_category')) {
            DB::statement('ALTER TABLE products CHANGE test_category category VARCHAR(50) NULL');
        }
    }
}
