<?php

namespace App\Models\Stock;

use App\Traits\CrudTrait;
use App\Scopes\CompanyScope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Product extends Model
{
    use HasFactory, CrudTrait, SoftDeletes;

    protected static function booted()
    {
        static::addGlobalScope(new CompanyScope);
    }

    protected $fillable = [
        'company_id',
        'quantity',
        'code',
        'pcode',
        'reference',
        'name',
        'image',
        'packaging',
        'unit_id',
        'cost_price',
        'rhia_price',
        'private_price',
        'inter_price',
        'category_id',
        'parent_id',
        'normal_range',
        'description',
        'test_category',
        'created_by',
        'is_storable',
    ];

    /**
     * Parent product (for lab panels / sub-tests).
     */
    public function parent()
    {
        return $this->belongsTo(Product::class, 'parent_id');
    }

    /**
     * Child products (e.g. panel analytes).
     */
    public function children()
    {
        return $this->hasMany(Product::class, 'parent_id');
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id')
                    ->select('units.id', 'units.name')
                    ->withTrashed();
    }

    /**
     * @return BelongsTo
    */
    public function expiry()
    {
        return $this->belongsTo(StockinHistory::class, 'id', 'product_id')
                    ->select('product_id', 'expiration_date')
                    ->withTrashed();
    }

    /**
     * @ return HasMany
     */

    public function ProductChanges(){
        return $this->hasMany(ProductChange::class)
                    ->select('id','product_id','quantity','price','batch_nber','expiration_date','created_by');
    }

    public function category()
    {
        return $this->belongsTo(ProductCategory::class, 'category_id')
                    ->select('product_categories.id', 'product_categories.name')
                    ->withTrashed();
    }
}
