<?php

namespace App\Models\Stock;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PaymentMode extends Model
{
    use HasFactory;
    protected $table = "payment_methods";
    protected $fillable = [
        'name',
        'currency',
        'description',
        'create_user'
    ];
 
    /**
     * @return BelongsTo
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'create_user', 'id')
                    ->select('id', 'name')
                    ->withTrashed();
    }
}
