<?php

namespace App\Imports;

use Carbon\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ProductImport implements ToCollection, WithHeadingRow
{
    /**
    * @param Collection $collection
    */
    protected $importedData = [];
    protected $missingColumns = [];
    public function collection(Collection $collection)
    {
        $desiredColumns = [
            'name',
            'packaging',
            'selling_price',
            'purchase_price',
        ];
        foreach ($collection as $row) {
            $selectedData = [];
            foreach ($desiredColumns as $columnName) {
                $columnKey = strtolower(str_replace(' ', '_', strtolower($columnName)));
                if (isset($row[$columnName])) {
                    $selectedData[$columnKey] = $row[$columnName];
                }else{
                    $selectedData[$columnKey] = 'N/A';
                    $this->missingColumns[] = $columnName;
                }
            }
            $this->importedData[] = $selectedData;
        }
    }

    public function getImportedData()
    {
        return $this->importedData;
    }

    public function getMissingColumns()
    {
        return $this->missingColumns;
    }
}
