<?php

namespace App\Http\Controllers\Stock;

use Illuminate\Http\Request;
use App\Models\Stock\PaymentMode;
use App\Http\Controllers\Controller;

class PaymentModeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        return response()->json([
            'status' => 1,
            'rows'   => PaymentMode::orderByDesc('id')->with('creator')->get()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        //if request has Id, then peform update
        if ($request->has('id')) {
            $PaymentMode = PaymentMode::find($request->input('id'));
        } else {
            $PaymentMode = new PaymentMode();
        }
        $PaymentMode->name=$request->input('name');
        $PaymentMode->description = $request->input('description') ? $request->input('description') : 'N/A';
        $PaymentMode->currency = $request->input('currency') ? $request->input('currency') : 'N/A';
        $PaymentMode->create_user = auth()->id();
        $PaymentMode->save();

        return response()->json([
            'status' => 1,
            'row'    => PaymentMode::find($PaymentMode->id)
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $PaymentMode = PaymentMode::findOrFail($id);
        if (!$PaymentMode) {
            return response()->json([
                'status' => 0,
                'error'  => 'PaymentMode not found'
            ]);
        }

        return response()->json([
            'status' => 1,
            'row'    => $PaymentMode
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $is
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        $PaymentMode = PaymentMode::findOrFail($id);
        if (!$PaymentMode) {
            return response()->json([
                'status' => 0,
                'error'  => 'PaymentMode not found'
            ]);
        }

        $PaymentMode->delete();

        return response()->json([
            'status' => 1,
            'message' => "Deleted sucessfully"
        ]);
    }

        /**
     * search fora category
     * @param Request $request
     * @return JsonResponse
     */
    public function search(Request $request)
    {
        $result = PaymentMode::select('id', 'name');
        $keyword = $request->get('query');
        if (empty($keyword)) {
            return  response()->json($result->orderBy('name', 'ASC')->take(250)->get());
        } else {
            return response()->json($result->where('name', 'LIKE', '%' . $keyword . '%')->orderBy('name', 'ASC')->get());
        }
    }
}
