<?php

namespace App\Http\Controllers\Stock;

use Illuminate\Http\Request;
use App\Models\Stock\Currency;
use App\Http\Controllers\Controller;

class CurrencyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        return response()->json([
            'status' => 1,
            'rows'   => Currency::orderByDesc('id')->with('creator')->get()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        //if request has Id, then peform update
        if ($request->has('id')) {
            $Currency = Currency::find($request->input('id'));
        } else {
            $Currency = new Currency();
        }
        $Currency->name=$request->input('name');
        $Currency->description=$request->input('description') ? $request->input('description') : 'N/A';
        $Currency->create_user = auth()->id();
        $Currency->save();

        return response()->json([
            'status' => 1,
            'row'    => Currency::find($Currency->id)
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $Currency = Currency::findOrFail($id);
        if (!$Currency) {
            return response()->json([
                'status' => 0,
                'error'  => 'Currency not found'
            ]);
        }

        return response()->json([
            'status' => 1,
            'row'    => $Currency
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $is
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        $Currency = Currency::findOrFail($id);
        if (!$Currency) {
            return response()->json([
                'status' => 0,
                'error'  => 'Currency not found'
            ]);
        }

        $Currency->delete();

        return response()->json([
            'status' => 1,
            'message' => "Deleted sucessfully"
        ]);
    }

        /**
     * search fora category
     * @param Request $request
     * @return JsonResponse
     */
    public function search(Request $request)
    {
        $result = Currency::select('id', 'name');
        $keyword = $request->get('query');
        if (empty($keyword)) {
            return  response()->json($result->orderBy('name', 'ASC')->take(250)->get());
        } else {
            return response()->json($result->where('name', 'LIKE', '%' . $keyword . '%')->orderBy('name', 'ASC')->get());
        }
    }
}
